//---------------------------
// UCL-CEREM-MBS
//
// @version MBsysLab_s 1.7.a
//
// Creation : 2006
// Last update : 01/10/2008
//---------------------------

#include "math.h" 

#include "mbs_data.h"
#include "user_model.h"
#include "set_output.h"
#include "useful_functions.h"

#include "user_all_id.h"
#include "user_model.h"

double* user_JointForces(MbsData *mbs_data, double tsim)
{
/*-- Begin of user code --*/

      //Update the the steerwheel torque on topic or in user_dirdyn_loop
     // if(mbs_data->process ==2) //direct dynamics
      //   {
       //    (*mbs_data->user_model->thread.thread_struct->pointeur_give_torque_access)();
       //  }

    if (tsim == 0.0) // equilibrium process and modal analysis
    {
        mbs_data->Qq[R2_wheel_rr_lt_id] = mbs_data->user_model->EquilQuantities.Qpropulsion;
        mbs_data->Qq[R2_wheel_rr_rt_id] = mbs_data->user_model->EquilQuantities.Qpropulsion;
        mbs_data->Qq[T2_rack_id] = mbs_data->user_model->EquilQuantities.Qrack;
    }

  // printf("Propulsion : %f \n",mbs_data->user_model->EquilQuantities.Qpropulsion);

    if(mbs_data->process == 2)
    {
     //if(tsim > 2) mbs_data->user_model->PID.velocity = 70/3.6;

     //CONTROLEUR PID
      double error = mbs_data->user_model->PID.velocity - (sqrt(pow(mbs_data->qd[1],2)+pow(mbs_data->qd[2],2)));
      
      if(error >= -0.1 && error <= 0.1) mbs_data->user_model->PID.sum_error = 0;
      
      mbs_data->user_model->PID.sum_error += error;
      
      double error_variation = error-mbs_data->user_model->PID.previous_error;

      mbs_data->user_model->PID.previous_error = error;

      double commande  = mbs_data->user_model->PID.Kp*error+ mbs_data->user_model->PID.Ki*mbs_data->user_model->PID.sum_error + mbs_data->user_model->PID.Kd*error_variation;

      mbs_data->Qq[R2_wheel_rr_lt_id] = mbs_data->user_model->EquilQuantities.Qpropulsion + commande;
      mbs_data->Qq[R2_wheel_rr_rt_id] = mbs_data->user_model->EquilQuantities.Qpropulsion + commande;



    // if(tsim == 0)
     // {
       //mbs_data->Qq[R2_wheel_rr_lt_id] = mbs_data->user_model->EquilQuantities.Qpropulsion;
       //mbs_data->Qq[R2_wheel_rr_rt_id] = mbs_data->user_model->EquilQuantities.Qpropulsion;
     // }
     // else
     // {
      //  mbs_data->Qq[R2_wheel_rr_lt_id] = -665;
      // mbs_data->Qq[R2_wheel_rr_rt_id] = -665;
      //  mbs_data->Qq[R2_wheel_ft_lt_id] = -1235;
     //  mbs_data->Qq[R2_wheel_ft_rt_id] = -1235;
     // }
    }

    // anti-roll bar
    mbs_data->Qq[R2_def_bar_ft_id] = -mbs_data->user_model->FrontSuspension.C_bar*mbs_data->q[R2_def_bar_ft_id];
    mbs_data->Qq[R2_def_bar_rr_id] = -mbs_data->user_model->RearSuspension.C_bar*mbs_data->q[R2_def_bar_rr_id];


   


    return mbs_data->Qq;
}
