   /**
    *
    *   Universite catholique de Louvain
    *   CEREM : Centre for research in mechatronics
    *   http://www.robotran.be  
    *   Contact : info@robotran.be
    *
    *
    *   MBsysC main script template for simple model:
    *   -----------------------------------------------
    *    This template loads the data file *.mbs and execute:
    *      - the coordinate partitioning module
    *      - the direct dynamic module (time integration of
    *        equations of motion).
    *    It may be adapted and completed by the user.
    * 
    *    (c) Universite catholique de Louvain
    *
    * To turn this file as a C++ file, just change its extension to .cc (or .cpp).
    * If you plan to use some C++ files, it is usually better that the main is compiled as a C++ function.
    * Currently, most compilers do not require this, but it is a safer approach to port your code to other computers.
    */

#include <stdio.h>
#include "mbs_data.h"
#include "mbs_dirdyn.h"
#include "mbs_part.h"
#include "realtime.h"
#include "mbs_set.h"
#include "mbs_loader.h"
#include "cmake_config.h"

#include "mbs_equil.h"
#include "user_all_id.h"
#include "user_model.h"
//#include "thread_struct.h"

#include "ros/ros.h"
#include "std_msgs/String.h"
#include "ros_rob/Torque_msg.h"
#include "ros_rob/Pos_vit_msg.h"
#include "std_msgs/MultiArrayLayout.h"
#include "std_msgs/MultiArrayDimension.h"
#include "std_msgs/UInt8MultiArray.h"

#include <sstream>

#include "pthread.h"
#include <bits/stdc++.h> 



int robotran_finish = 0;

pthread_cond_t condition = PTHREAD_COND_INITIALIZER; 
pthread_cond_t condition_2 = PTHREAD_COND_INITIALIZER; 
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER; 

MbsData *mbs_data;

int send_torque_pdo(std::map<int, char> m,std_msgs::UInt8MultiArray torque_can_msg,int16_t torque_can,ros::Publisher chatter_pub);
int send_torque_pdo(std::map<int, char> m,std_msgs::UInt8MultiArray torque_can_msg,int16_t torque_can,ros::Publisher chatter_pub)
{
    torque_can_msg.data.push_back(0x2B);
    torque_can_msg.data.push_back(0x71);
    torque_can_msg.data.push_back(0x60);


    //from https://www.geeksforgeeks.org/convert-decimal-to-hexa-decimal-including-negative-numbers/
    
    // string to be returned 
    std::string res = ""; 
    
    if(torque_can == 0) { 
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);

        chatter_pub.publish(torque_can_msg);

        return 0;
    } 
    else if(torque_can > 0){
        while (torque_can) { 
            res = m[torque_can % 16] + res; 
            torque_can /= 16; 
        } 
    }
    else { 
        
        u_int n = torque_can; 
  
        while (n) { 
            res = m[n % 16] + res; 
            n /= 16; 
        } 
    } 

    
    char str[4];
    str[0] = '0';
    str[1] = 'x';


    if(res.size()==1)
    {
        
        int torque_hex;
        str[2] = '0';
        str[3] = res[0];
        sscanf(str,"%x",&torque_hex);

        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(torque_hex);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);

        chatter_pub.publish(torque_can_msg);
        return 0;
    }
    else if(res.size()==2)
    {
        
        int torque_hex;
        str[2] = res[0];
        str[3] = res[1];
        sscanf(str,"%x",&torque_hex);

        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(torque_hex);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);

        chatter_pub.publish(torque_can_msg);
        return 0;
    }
    else if(res.size()==3)
    {
        
        int torque_hex;
        int torque_hex_2;

        str[2] = '0';
        str[3] = res[0];
        sscanf(str,"%x",&torque_hex);

        str[2] = res[1];
        str[3] = res[2];
        sscanf(str,"%x",&torque_hex_2);
        
        torque_can_msg.data.push_back(torque_hex);
        torque_can_msg.data.push_back(torque_hex_2);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);

        chatter_pub.publish(torque_can_msg);
        return 0;
    }
    else if(res.size() >= 4)
    {
        
        int torque_hex;
        int torque_hex_2;

        str[2] = res[res.size()-4];
        str[3] = res[res.size()-3];
        sscanf(str,"%x",&torque_hex);

        str[2] = res[res.size()-2];
        str[3] = res[res.size()-1];
        sscanf(str,"%x",&torque_hex_2);
        
        torque_can_msg.data.push_back(torque_hex);
        torque_can_msg.data.push_back(torque_hex_2);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);
        torque_can_msg.data.push_back(0x00);

        chatter_pub.publish(torque_can_msg);
        return 0;
    }

}


void give_torque_access();

void give_pos_vit_access();

void give_torque_access()
{
	//access for torque
	 pthread_mutex_lock (&mutex); 
     pthread_cond_signal(&condition); 
     pthread_mutex_unlock (&mutex);
}

void give_pos_vit_access()
{
   //access for pos and vit
     pthread_mutex_lock (&mutex); 
     pthread_cond_signal(&condition_2); 
     pthread_mutex_unlock (&mutex);
}

void chatterCallback(const ros_rob::Pos_vit_msg& msg)
{
       mbs_data->q[R1_steerwheel_id] = msg.pos_value;
       if(mbs_data->q[R1_steerwheel_id] > 8)
       {
        mbs_data->q[R1_steerwheel_id] = 8;
       }
       else if(mbs_data->q[R1_steerwheel_id] < -8)
       {
        mbs_data->q[R1_steerwheel_id] = -8;
       }
       mbs_data->qd[R1_steerwheel_id] = msg.vit_value; 
}

void *ros_posvit_thread_3(void *arg_data_3) //listener
{
	sleep(1); 

	ros::NodeHandle pos_vit_lis;
   
   // ros::Subscriber sub_pos = pos_vit_lis.subscribe("chatter_pos_vit", 1000, chatterCallback); 
	 ros::Subscriber sub_pos = pos_vit_lis.subscribe("/keyboard/chatter_pos_vit", 1, chatterCallback);    

    while (robotran_finish != 1)
     {
     	pthread_mutex_lock(&mutex); 
        pthread_cond_wait(&condition_2,&mutex);
   
        ros::spinOnce(); //call chatterCallback once

        pthread_mutex_unlock (&mutex);
     }

    printf("ROS Pos & Vit finish ! \n");
    pthread_exit(NULL);
}



void *ros_torque_thread_1(void *arg_data_1) //publisher
{
  
     ros::NodeHandle torque_pub;

     ros::Publisher chatter_pub = torque_pub.advertise<std_msgs::UInt8MultiArray>("/keyboard/chatter_torque", 1); 

     // ros_rob::Torque_msg torque;

      //torque.robotran_is_finish = false;

     double torque_value;
     int16_t torque_can;

     double torque_init = 1030; //[Ncm], continuous torque at standstill of the servo-motor 

     std_msgs::UInt8MultiArray torque_can_msg;

    
    std::map<int,char> m; 
  
    char digit = '0'; 
    char c = 'a'; 
  
    for (int i = 0; i <= 15; i++) { 
        if (i < 10) { 
            m[i] = digit++; 
        } 
        else { 
            m[i] = c++; 
        } 
    } 
    
      while (robotran_finish != 1)
        {

             torque_can_msg.data.clear();

             pthread_mutex_lock(&mutex); 

		     pthread_cond_wait(&condition, &mutex);

             torque_value = -mbs_data->Qc[R1_steerwheel_id];            

             pthread_mutex_unlock (&mutex);

             torque_can = (int16_t) std::min(300.0,(std::max(-300.0,(torque_value*10000.0)/torque_init))); 
  
             send_torque_pdo(m,torque_can_msg,torque_can,chatter_pub);

            // ROS_INFO("Couple = %f", torque.value);

             //chatter_pub.publish(torque);

        }

        //torque.robotran_is_finish = true;
        //chatter_pub.publish(torque);

     printf("ROS Torque finish ! \n");

     pthread_exit(NULL);
}

void *robotran_thread_2(void *arg_data_2)
{   
	sleep(1); //pour arriver a la condition wait

  
    MbsPart *mbs_part;
    MbsDirdyn *mbs_dirdyn;
    MbsEquil *mbs_equil;

    ROS_INFO("Start Robotran");

    printf("Starting Car MBS project!\n");


    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                     LOADING                               *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    
    printf("Loading the Car data file !\n");
    mbs_data = mbs_load(PROJECT_SOURCE_DIR"/../dataR/Car.mbs", BUILD_PATH);
    printf("*.mbs file loaded!\n");

    ThreadStruct *thread_struct; 

    thread_struct = (ThreadStruct*)malloc(sizeof(ThreadStruct));

    thread_struct->pointeur_give_torque_access = give_torque_access;

    thread_struct->pointeur_give_pos_vit_access = give_pos_vit_access;

    mbs_data->user_model->thread.thread_struct = thread_struct; 

    mbs_data->user_model->PID.sum_error = 0.0;

    mbs_data->user_model->PID.Kp = 250.0;

    mbs_data->user_model->PID.Ki = 0.00;

    mbs_data->user_model->PID.Kd = 100;

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	/*                     CONSTRAINT                            *
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

	int N_usr_c = 6;
	mbs_set_nb_userc(mbs_data, N_usr_c);

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*              COORDINATE PARTITIONING                      *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
   
    mbs_part = mbs_new_part(mbs_data);
    mbs_part->options->rowperm=1;
    mbs_part->options->verbose = 0;
    mbs_run_part(mbs_part, mbs_data);
    mbs_delete_part(mbs_part);

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                STATIC EQUILIBRIUM at given height         *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


  //  mbs_data->dpt[2][47] = -0.559461; //wheel orientation (doesn't work)
   // mbs_data->dpt[2][48] = 0.54;
   
    mbs_data->process = 1;
    mbs_equil = mbs_new_equil(mbs_data);
    // equil options (see documentations for additional options)
    mbs_equil->options->senstol = 1e-2; //1e-2
    mbs_equil->options->devjac = 1e-2; //1e-2
	//mbs_equil->options->equitol = 7e-4;
    mbs_equil->options->verbose = 0;
    mbs_equil->options->resfilename = "static_1";

    mbs_data->q[R2_chassis_id] = 0.0;
    mbs_data->q[T3_chassis_id] = 0.2;


    // --- Variable exchange, quch->xch
    mbs_equil->options->nquch = 2; // nquch = nxch number of exchanged variables
    mbs_equil_exchange(mbs_equil->options); // allocates the memory
    mbs_equil->options->quch[1] = T3_chassis_id; // which free coordinate has to be replaced
    mbs_equil->options->xch_ptr[1] = &(mbs_data->user_model->FrontSuspension.L0); // which variable is the new one
    mbs_equil->options->quch[2] = R2_chassis_id;
    mbs_equil->options->xch_ptr[2] = &(mbs_data->user_model->RearSuspension.L0);

    // equilibrium procedure
    mbs_run_equil(mbs_equil, mbs_data);
    mbs_print_equil(mbs_equil);
    mbs_delete_equil(mbs_equil, mbs_data); //mettre en commentaire si on veut faire wheel orientation


    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                STATIC EQUILIBRIUM set wheel orientation   *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*  NE FONCTIONNE PAS SUR LINUX

    mbs_data->process = 1;
    mbs_equil = mbs_new_equil(mbs_data);
    // equil options (see documentations for additional options)
    mbs_equil->options->senstol = 1e-2; //1e-2
    mbs_equil->options->devjac = 1e-2; //1e-2
    mbs_equil->options->verbose = 1;
    mbs_equil->options->equitol = 0.222;
    //mbs_equil->options->itermax = 100;
    mbs_equil->options->resfilename = "static_2";
    // --- Variable addition, xe (straight wheels)
    mbs_equil->options->nxe = 2;
    mbs_equil_addition(mbs_equil->options);

    mbs_equil->options->xe_ptr[1] = &(mbs_data->dpt[2][47]); //44 de base, augmentation car rajout de 3 anchor points
    mbs_equil->options->xe_ptr[2] = &(mbs_data->dpt[2][48]); //45


    mbs_run_equil(mbs_equil, mbs_data);
    mbs_print_equil(mbs_equil);
    mbs_delete_equil(mbs_equil, mbs_data);

   //mbs_print_user_model(mbs_data->user_model);


    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                STRAIGHT LINE  EQUILIBRIUM                 *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

   double V = 50/3.6;

    mbs_data->user_model->PID.velocity = V;
    mbs_data->user_model->PID.sum_error = 0;
    mbs_data->user_model->PID.previous_error = 0;


   
    printf("-----------------Straight line equil-----------------\n");


    mbs_data->process = 2;
    mbs_equil = mbs_new_equil(mbs_data);
    // equil options (see documentations for additional options)
    mbs_equil->options->senstol = 1e-06; 
    mbs_equil->options->devjac = 1e-05;
    mbs_equil->options->equitol = 1.5; //DIMINUER LE RESIDU (OLD : 4.5)
//	mbs_equil->options->itermax = 100;
    mbs_equil->options->verbose = 0;
    mbs_equil->options->mode = 2;
    mbs_equil->options->resfilename = "sl";

    // set a desired speed
    mbs_data->qd[T1_chassis_id] = V; //[m/s]
                                         // calculation of the true height of the center of the wheel = R_wheel (0.3) - penetration
                                         // see in ExtForces : printf("%f\n", PxF[3]); height of the sensor
    mbs_data->qd[R2_wheel_ft_rt_id] = V / 0.279422;
    mbs_data->qd[R2_wheel_ft_lt_id] = V / 0.279422;
    mbs_data->qd[R2_wheel_rr_lt_id] = V / 0.280650;
    mbs_data->qd[R2_wheel_rr_rt_id] = V / 0.280650;
    // --- Variable exchange, quch->xch
    mbs_equil->options->nquch = 5; // nquch = nxch number of exchanged variables
    mbs_equil_exchange(mbs_equil->options); // allocates the memory
    mbs_equil->options->quch[1] = T1_chassis_id; // which free coordinate has to be replaced
    mbs_equil->options->xch_ptr[1] = &(mbs_data->user_model->EquilQuantities.Qpropulsion); // which variable is the new one
    mbs_equil->options->quch[2] = R2_wheel_ft_rt_id;
    mbs_equil->options->xch_ptr[2] = &(mbs_data->qd[R2_wheel_ft_rt_id]);
    mbs_equil->options->quch[3] = R2_wheel_ft_lt_id;
    mbs_equil->options->xch_ptr[3] = &(mbs_data->qd[R2_wheel_ft_lt_id]);
    mbs_equil->options->quch[4] = R2_wheel_rr_lt_id;
    mbs_equil->options->xch_ptr[4] = &(mbs_data->qd[R2_wheel_rr_lt_id]);
    mbs_equil->options->quch[5] = R2_wheel_rr_rt_id;
    mbs_equil->options->xch_ptr[5] = &(mbs_data->qd[R2_wheel_rr_rt_id]);
    // equilibrium procedure
    mbs_run_equil(mbs_equil, mbs_data);
    mbs_print_equil(mbs_equil);



    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                SS CORNERING  EQUILIBRIUM                  *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

	//Equilibre impossible avec le systeme de direction
   /*printf("-----------------SS cornering equil-----------------\n");
	
    // conditions initiales pour la vitesse de rotation des roues (approximation rsg)
    mbs_data->qd[T1_chassis_id] = V;
    mbs_data->qd[R2_wheel_ft_lt_id] = V / 0.279572;
    mbs_data->qd[R2_wheel_ft_rt_id] = V / 0.279572;
    mbs_data->qd[R2_wheel_rr_lt_id] = V / 0.280501;
    mbs_data->qd[R2_wheel_rr_rt_id] = V / 0.280501;

    V = 10;
    double R = 100; 
    int i;
    for (i = 100; i > 15 ; i--) // looping on the radius from R=100 m allows to reach R=20 m for V=10.
    {
        R = i;
        mbs_data->q[T2_chassis_id] = -R;   // Does not intervene : -R
        mbs_data->qd[T1_chassis_id] = V;
        mbs_data->qd[R3_chassis_id] = +V / R;
        mbs_data->qdd[T2_chassis_id] = +V * V / R;

        mbs_equil = mbs_new_equil(mbs_data);
		
        // options
        mbs_equil->options->verbose = 1;
        mbs_equil->options->mode = 3;
        mbs_data->process = 2;
        mbs_equil->options->senstol = 1e-3;
        mbs_equil->options->devjac = 1e-6;
		mbs_equil->options->equitol = 1e-3;
        mbs_equil->options->itermax = 50;
        mbs_equil->options->resfilename = "equil_cornering";
        // --- Variable exchange, quch->xch
        mbs_equil->options->nquch = 6;
        mbs_equil_exchange(mbs_equil->options);
        mbs_equil->options->quch[1] = T1_chassis_id;
        mbs_equil->options->xch_ptr[1] = &(mbs_data->user_model->EquilQuantities.Qpropulsion);
        mbs_equil->options->quch[2] = R2_wheel_ft_lt_id;
        mbs_equil->options->xch_ptr[2] = &(mbs_data->qd[R2_wheel_ft_lt_id]);
        mbs_equil->options->quch[3] = R2_wheel_ft_rt_id;
        mbs_equil->options->xch_ptr[3] = &(mbs_data->qd[R2_wheel_ft_rt_id]);
        mbs_equil->options->quch[4] = R2_wheel_rr_lt_id;
        mbs_equil->options->xch_ptr[4] = &(mbs_data->qd[R2_wheel_rr_lt_id]);
        mbs_equil->options->quch[5] = R2_wheel_rr_rt_id;
        mbs_equil->options->xch_ptr[5] = &(mbs_data->qd[R2_wheel_rr_rt_id]);
        mbs_equil->options->quch[6] = T2_chassis_id;
        mbs_equil->options->xch_ptr[6] = &(mbs_data->user_model->EquilQuantities.Qrack);
        mbs_run_equil(mbs_equil, mbs_data);
        mbs_delete_equil(mbs_equil, mbs_data);
    }


    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                   DIRECT DYNANMICS                        *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
	
    mbs_set_qdriven(mbs_data, R1_steerwheel_id); // qu ou qdriven

    mbs_data->process = 2; 
    mbs_dirdyn = mbs_new_dirdyn(mbs_data);

    // dirdyn options (see documentations for additional options)
    mbs_dirdyn->options->dt0 = 0.82*1e-3; 
    mbs_dirdyn->options->tf  = 3.0;
    mbs_dirdyn->options->save2file = 1;
    mbs_dirdyn->options->realtime = 1;
    
    mbs_run_dirdyn(mbs_dirdyn, mbs_data);

    mbs_delete_dirdyn(mbs_dirdyn, mbs_data);
    
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                   CLOSING OPERATIONS                      *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
     

    free(thread_struct);

    pthread_mutex_lock (&mutex); 
    robotran_finish = 1;
    pthread_cond_signal(&condition); 
    pthread_cond_signal(&condition_2); 
    pthread_mutex_unlock (&mutex);

     sleep(1); 
    give_torque_access(); //pour etre sur que les threads ROS se finissent correctement
    give_pos_vit_access(); 

    mbs_delete_data(mbs_data);
    printf("Robotran finish ! \n");

   
    pthread_exit(NULL);
}




int main(int argc, char *argv[])
{
     pthread_t thread1; //ROS_torque thread
     pthread_t thread2; //Robotran thread
     pthread_t thread3; //ROS_posvit thread

     ros::init(argc, argv, "rosbotran");

    if(pthread_create(&thread2, NULL, robotran_thread_2, NULL) == 0  && pthread_create(&thread1, NULL, ros_torque_thread_1, NULL) == 0 && pthread_create(&thread3, NULL, ros_posvit_thread_3, NULL) == 0)
    {

          pthread_join(thread1, NULL);
          pthread_join(thread2, NULL);
          pthread_join(thread3, NULL);

    }
    else
    {
    	printf("Error : thread not created");

    	return -1;
    }
  
    pthread_mutex_destroy(&mutex);
  
    printf("Code finish \n");

    return 0;
}

